clc;
clear;
tic;
input1='G:\Nmodel Input\01\';
input2='G:\Nmodel Input\02\';
input3='G:\Nmodel Input\03-Knitr0.33Kdntr0.25FfertT9000\';
input4='G:\Model coupling-NLAT\NLAT1GSWPMonth1\Stomate\';
input5='G:\Nmodel Input\01\ManureZhang\ManNitProHalfDegree\';
inputsewage='G:\Nmodel Input\01\Sewage\';
inputAmend='G:\Nmodel Input\AmendData\';
output='G:\Nmodel Output\03-Knitr0.33Kdntr0.25FfertT9000TS20240507\Flow\';
outputt='G:\Nmodel Output\03-Knitr0.33Kdntr0.25FfertT9000TS20240507\';
%%%%%%%%%%%%%%%%%%%%% read routing  and topoind data %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Trip=load([inputAmend,'FlowDirectionAmend.txt']);
basin1=ncread([input1,'routing_20211020.nc'],'basins_zhc');
basin2=double(fliplr(rot90(basin1,-1)));
basin3=basin2(80:125,130:205);
basin3(basin3~=1139)=0;

RCbasin=xlsread([outputt,'Basin1.xlsx'],'sheet3','P3:Q5525');
DischargeObs=xlsread([outputt,'Basin1.xlsx'],'sheet3','P3:Q5525');
BasinNum=length(RCbasin);

%Trip(Trip>100)=0;
% trip = 1 : flow = N
% trip = 2 : flow = NE
% trip = 3 : flow = E
% trip = 4 : flow = SE
% trip = 5 : flow = S
% trip = 6 : flow = SW
% trip = 7 : flow = W
% trip = 8 : flow = NW
% trip = 97 : return flow into the ground
% trip = 98 : coastal flow (diffuse flow into the oceans)
% trip = 99 : river flow into the oceans  

TopoindD=load([inputAmend,'TopoindAmend.txt']);
TopoindD(Trip>100)=nan;
TopoindD(TopoindD>100000000000000)=nan;

dlmwrite([outputt,'FlowDirection.txt'],Trip,'delimiter','\t'); % for test
dlmwrite([outputt,'Topoind.txt'],TopoindD,'delimiter','\t'); % for test
rowA=360;
colA=720;
A=1:1:259200;

TripdownID=reshape(A,[rowA,colA]);  % calculate the downstream ID 
clear A
dlmwrite([outputt,'ID0.txt'],TripdownID,'delimiter','\t');
TripdownID(Trip==1)=TripdownID(Trip==1)-1;
TripdownID(Trip==2)=TripdownID(Trip==2)-1+rowA;
TripdownID(Trip==3)=TripdownID(Trip==3)+rowA;
TripdownID(Trip==4)=TripdownID(Trip==4)+1+rowA;
TripdownID(Trip==5)=TripdownID(Trip==5)+1;
TripdownID(Trip==6)=TripdownID(Trip==6)+1-rowA;
TripdownID(Trip==7)=TripdownID(Trip==7)-rowA;
TripdownID(Trip==8)=TripdownID(Trip==8)-1-rowA;
TripdownID(Trip==97)=0;
TripdownID(Trip==98)=-1;
TripdownID(Trip==99)=-2;
TripdownID(Trip>=100)=-3;
dlmwrite([outputt,'ID.txt'],TripdownID,'delimiter','\t');

VID=find(TripdownID>0&TripdownID<259200); % The gride need to focus on
IDnum=length(VID);

file2=dir([input2,'Global-hist-yearly1*sechiba_history.nc']);
fileNum=length(file2);
file3=dir([input3,'gcp.lucfix.twodeg.trendyv10.M.S3*stomate_history.nc']);

fileSewage=dir([inputsewage,'Npoint*.asc']);
fast_Waterp=ones(rowA,colA).*0.00000001; % The base of the exponent cannot be 0
slow_Waterp=ones(rowA,colA).*0.00000001;
stream_Waterp=ones(rowA,colA).*0.00000001;

fast_PONp=zeros(rowA,colA);   % fast PON pool
fast_DONp=zeros(rowA,colA);   % fast DON pool
fast_DINp=zeros(rowA,colA);   % fast DIN pool
slow_DONp=zeros(rowA,colA);   % slow DON pool
slow_DINp=zeros(rowA,colA);   % slow DIN poo
stream_PONp=zeros(rowA,colA); % sream PON pool
stream_DONp=zeros(rowA,colA); % sream DON pool
stream_DINp=zeros(rowA,colA); % sream DIN pool


datasave=zeros(fileNum,34);
datasaveIN=zeros(fileNum,9);
for i=1 %:fileNum-6   %cycle for year
%     year1=str2double(file2(i).name(21:24));
    year1=str2double(file2(i).name(21:24));
    if mod(year1,4)==0 
        daynum=366;
    else 
        daynum=365;
    end
    disp(i);
    disp(year1);
    Depth=zeros(rowA,colA,daynum);
    
    flow_sream_water_day=zeros(rowA,colA,daynum);
    flow_sream_PON_day=zeros(rowA,colA,daynum);
    flow_sream_DON_day=zeros(rowA,colA,daynum);
    flow_sream_DIN_day=zeros(rowA,colA,daynum);
    
    flow_fast_water_day=zeros(rowA,colA,daynum);
    flow_fast_PON_day=zeros(rowA,colA,daynum);
    flow_fast_DON_day=zeros(rowA,colA,daynum);
    flow_fast_DIN_day=zeros(rowA,colA,daynum);
    
    flow_slow_water_day=zeros(rowA,colA,daynum);
    flow_slow_DON_day=zeros(rowA,colA,daynum);
    flow_slow_DIN_day=zeros(rowA,colA,daynum);

    flux_sream_PON_day=zeros(rowA,colA,daynum);
    flux_sream_DON_day=zeros(rowA,colA,daynum);
    flux_sream_DIN_day=zeros(rowA,colA,daynum);
    
    flux_fast_PON_day=zeros(rowA,colA,daynum);
    flux_fast_DON_day=zeros(rowA,colA,daynum);
    flux_slow_DON_day=zeros(rowA,colA,daynum);
    flux_fast_DINdntr_day=zeros(rowA,colA,daynum);
    flux_slow_DINdntr_day=zeros(rowA,colA,daynum);
    %%%%%%%%%%%%%%%%%%%%%%% read Global***sechiba.nc data%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    Areatemp=ncread([input2,file2(i).name],'Areas');     %Mesh areas, m2
    confrac1temp=ncread([input2,file2(i).name],'Contfrac'); 
    confrac1temp(isnan(confrac1temp))=0;
    TStemp=ncread([input2,file2(i).name],'temp_sol'); %Average surface temperature,℃
    Runofftemp=ncread([input2,file2(i).name],'runoff');
%    Surface runoff,mm/d
    Drainagetemp=ncread([input2,file2(i).name],'drainage');
%     Deep drainage,mm/d
    POCActRtemp=ncread([input2,file2(i).name],'POCact_inp_runoff');
%     POC_active export from topsoil,g/m^2/d
    POCSlowRtemp=ncread([input2,file2(i).name],'POCslow_inp_runoff');
%     POC_slow export from topsoil,g/m^2/d
    POCPasRtemp=ncread([input2,file2(i).name],'POCpas_inp_runoff');
%     POC_active export from topsoil,g/m^2/d
    DOCLabRtemp=ncread([input2,file2(i).name],'DOClab_inp_runoff');
%     labile DOC export from topsoilwith runff,g/m^2/d
    DOCRefRtemp=ncread([input2,file2(i).name],'DOCref_inp_runoff');
%     refractory DOC export from topsoilwith runoff,g/m^2/d
    DOCLabDtemp=ncread([input2,file2(i).name],'DOClab_inp_drainage');
%     labile DOC export from subsoil with drainage,g/m^2/d
    DOCrefDtemp=ncread([input2,file2(i).name],'DOCref_inp_drainage');

    Area=fliplr(imresize(rot90(Areatemp,-1),2,'nearest')./4);  
    confrac1= fliplr(imresize(rot90(confrac1temp,-1),2,'nearest'));
    TS= fliplr(imresize(rot90(TStemp,-1),2,'nearest'));
    TW = 6.13 + 0.80 .* TS; %water temperature

    Runoff = fliplr(imresize(rot90(Runofftemp,-1),2,'nearest')); %mm/d
    Drainage=fliplr(imresize(rot90(Drainagetemp,-1),2,'nearest'));
    POCR= fliplr(imresize(rot90(POCActRtemp./12.0+POCSlowRtemp./25.0+POCPasRtemp./8.0,-1),2,'nearest'));
    DOCR= fliplr(imresize(rot90(DOCLabRtemp+DOCRefRtemp,-1),2,'nearest'));
    DOCD= fliplr(imresize(rot90(DOCLabDtemp+DOCrefDtemp,-1),2,'nearest'));
    clear Areatemp TStemp Runofftemp Drainagetemp POCActRtemp POCSlowRtemp POCPasRtemp 
    clear DOCLabRtemp DOCRefRtemp DOCLabDtemp DOCrefDtemp Areatemp StreamIntemp StreamOuttemp  
    %%%%%%%%%%%%%%%%%%%%%% read Nsewage data%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %From 1900, every 5 years one data
    delimiterIn = ' ';
    headerlinesIn = 6;
    if year1<2000
        yearA=1900;
        yearB=year1-yearA;
        yearC=mod(yearB,5);
        yearD=floor(yearB/5);
        if yearC==0
            NsewageTT=importdata([inputsewage,fileSewage(yearD+1).name],delimiterIn,headerlinesIn);%kg N yr-1
            NsewageT=NsewageTT.data;
            NsewageT(NsewageT<0)=0;
            Nsewage=NsewageT.*1000.0./365.0; %gN/d
        else
            NsewageTT1=importdata([inputsewage,fileSewage(yearD+1 ).name],delimiterIn,headerlinesIn);%kg N yr-1
            NsewageT1=NsewageTT1.data;
            NsewageT1(NsewageT1<0)=0;
            
            NsewageTT2=importdata([inputsewage,fileSewage(yearD+2).name],delimiterIn,headerlinesIn);%kg N yr-1
            NsewageT2=NsewageTT2.data;
            NsewageT2(NsewageT2<0)=0;
            
            Nsewage=( NsewageT1+(NsewageT2-NsewageT1).*(yearC/5) ).*1000.0./365.0; %gN/d
        end
        
    else
        NsewageTT=importdata([inputsewage,fileSewage(21).name],delimiterIn,headerlinesIn);%kg N yr-1
        NsewageT=NsewageTT.data;
        NsewageT(NsewageT<0)=0;
        Nsewage=NsewageT.*1000.0./365.0; %gN/d
    end
    Nsewage(isnan(Nsewage))=-1;
%     dlmwrite([outputt,'Nsewage.txt'],Nsewage,'delimiter','\t');
    clear NsewageTT NsewageT NsewageTT1 NsewageT1 NsewageTT2 NsewageT2  
    
    %%%%%%%%%%%%%%%%%%%%%%% read gcp***stomate_history data%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    DayM1=[31,28,31,30,31,30,31,31,30,31,30,31];
    DayM2=[31,29,31,30,31,30,31,31,30,31,30,31];
    year2=str2double(file3(i).name(41:44));
    disp(year2);
    if mod(year2,4)==0 
        DayM=DayM2;
    else 
        DayM=DayM1;
    end

    NH4Leach=zeros(rowA,colA,daynum);
    NO3Leach=zeros(rowA,colA,daynum);
    
%     Nleach=zeros(rowA,colA,daynum);
    % ammonium leached below root zone,gNH4-N/m**2/day
    % lon,lat,veget,time_counter
    NO3LeachVegtemp=ncread([input3,file3(i).name],'NO3_LEACHING');
    % ammonium leached below root zone,gNH4-N/m**2/day
    NH4LeachVegtemp=ncread([input3,file3(i).name],'NH4_LEACHING');
    VegFtemp=ncread([input3,file3(i).name],'VEGET_COV_MAX'); %'Continental fraction'
    AreaVeg=ncread([input3,file3(i).name],'Areas');
    Contfrac=ncread([input3,file3(i).name],'CONTFRAC');

    DONLeachManure=zeros(rowA,colA,daynum);
    DONLeachManureExtra=zeros(rowA,colA,daynum);
    
    file4=[input4,'NLATGSWPMonth1_',num2str(year1),'0101_',num2str(year1),'1231_1M_stomate_history.nc'];
    Areas4=ncread(file4,'Areas');  %m2
    Areas4(isnan(Areas4))=0;
    confrac4=ncread(file4,'CONTFRAC');
    confrac4(isnan(confrac4))=0;
    DONLeachM=ncread(file4,'N_LEACHManure_DON');% unit gN/m2/day
    DONLeachM(isnan(DONLeachM))=0;
       
    dayth=1;
    for jmonth=1:12
        NH4Leachtemp=zeros(180,90,15);
        NO3Leachtemp=zeros(180,90,15);
        for jveg=1:15
            NH4Leachtemp(:,:,jveg)=NH4LeachVegtemp(:,:,jveg,jmonth).*VegFtemp(:,:,jveg,jmonth).*AreaVeg.*Contfrac;
            NO3Leachtemp(:,:,jveg)=NO3LeachVegtemp(:,:,jveg,jmonth).*VegFtemp(:,:,jveg,jmonth).*AreaVeg.*Contfrac;
        end

        NH4LeachtempAll=nansum(NH4Leachtemp,3);
        NO3LeachtempAll=nansum(NO3Leachtemp,3);
 
        NH4LeachR=(fliplr(imresize(rot90(NH4LeachtempAll,-1),4,'nearest')))./16;   %(2/3).*
        NO3LeachR=(fliplr(imresize(rot90(NO3LeachtempAll,-1),4,'nearest')))./16;  %(2/3).*
       
        DONLeachMR=(fliplr(imresize(rot90(DONLeachM(:,:,jmonth).*Areas4.*confrac4,-1),2,'nearest')))./4; %gN/day
        
        %%%%%%%%%%%%% for test%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        for jday=1:DayM(jmonth)
                NH4Leach(:,:,dayth)=NH4LeachR; %gNH4-N/m**2/day
                NO3Leach(:,:,dayth)=NO3LeachR; %gNO3-N/m**2/day
                DONLeachManure(:,:,dayth)=DONLeachMR %gNO3-N/m**2/day
%                 Nleach(:,:,dayth)=fNleachtemp2(:,:,jmonth); % kg N m-2 s-1
                %gN/day, assume that 20% of extra DON leaching into rivers
                disp(dayth);
                dayth=dayth+1;
        end % end of jday
        
    end % end of jmonth
    clear NH4LeachtempAll NO3LeachtempAll NH4LeachR NO3LeachR DONLeachM DONLeachMR 
    clear NO3LeachVegtemp NH4LeachVegtemp VegFtemp AreaVeg Contfrac Areas4 confrac4
    % we assume that the ratio of C and N is 12, and the concentration of DIN in runpff and drainage are the same
    
    PONR=POCR.*Area.*confrac1; 
    DONR=DOCR.*Area.*confrac1./12+DONLeachManure.*(Runoff./(Runoff+Drainage));                                                   % gN/m^2/d,three-dimensional matrice 
    DOND=DOCD.*Area.*confrac1./12+DONLeachManure.*(1-Runoff./(Runoff+Drainage));                                                   % gN/m^2/d,three-dimensional matrice 
    
    DINR=(NH4Leach+NO3Leach).*(Runoff./(Runoff+Drainage));   % gN/m^2/d,three-dimensional matrice 
    DIND=(NH4Leach+NO3Leach).*(Drainage./(Runoff+Drainage));   % gN/m^2/d,three-dimensional matrice 

    clear POCR DOCR DOCD NH4Leach NO3Leach 
    
    %******************************** strat of the calculating ******************************************************
    flow_coef = 1.01;  
    % Empericl coefficient for representing the turnover time between water storage and it turnover rate (unit less)
    fast_tcst = 3.0;        % Property of the fast reservoir, when CWRR hydrology is activated (day/m)
    slow_tcst = 25.0;       % Property of the slow reservoir, (day/m)
    stream_tcst = 0.24;     % Property of the stream reservoir, when CWRR hydrology is activated (day/m)
    %flood_tcst_cwrr = 4.0;       % Property of the floodplains reservoir, when CWRR hydrology is activated (day/m)
    min_sechiba = 0.00000001;    % Epsilon to detect a near zero floating point (unitless)
    
    fT_PON = 2.^((TW-20)./10);% temperature factor for PON decompostion,three-dimensional matrice
    fT_DON = 2.^((TW-20)./10); % temperature factor for DON decompostion,three-dimensional matrice
    fT_DIN = exp(-(TW-25.0).^2./(21*21)); % temperature factor for DIN denitrification,three-dimensional matrice
       
    for iday= 1:daynum
        % flow of water and N
        flow_fast_Water   = min((fast_Waterp.^flow_coef)./((TopoindD./1000.0).*fast_tcst),fast_Waterp-min_sechiba);
        flow_slow_Water   = min((slow_Waterp.^flow_coef)./((TopoindD./1000.0).*slow_tcst),slow_Waterp-min_sechiba);
        flow_stream_Water = min((stream_Waterp.^flow_coef)./((TopoindD./1000.0).*stream_tcst),stream_Waterp-min_sechiba);  % m3/day 
        %flow_flood  = min((flood_reservoir.^flow_coef)./((TopoindD./1000.0)*flood_tcst.*flood_frac_bas),flood_reservoir-min_sechiba);
       
        flow_fast_PON =  min((flow_fast_Water./fast_Waterp).*fast_PONp,fast_PONp-min_sechiba);
        flow_fast_DON =  min((flow_fast_Water./fast_Waterp).*fast_DONp,fast_DONp-min_sechiba);
        flow_fast_DIN =  min((flow_fast_Water./fast_Waterp).*fast_DINp,fast_DINp-min_sechiba);
        flow_slow_DON =  min((flow_slow_Water./slow_Waterp).*slow_DONp,slow_DONp-min_sechiba);
        flow_slow_DIN =  min((flow_slow_Water./slow_Waterp).*slow_DINp,slow_DINp-min_sechiba);
        flow_stream_PON =  min((flow_stream_Water./stream_Waterp).*stream_PONp,stream_PONp-min_sechiba);
        flow_stream_DON =  min((flow_stream_Water./stream_Waterp).*stream_DONp,stream_DONp-min_sechiba);
        flow_stream_DIN =  min((flow_stream_Water./stream_Waterp).*stream_DINp,stream_DINp-min_sechiba);
        
        flow_fast_PON(Trip==97)=0;
        flow_fast_DON(Trip==97)=0;
        flow_fast_DIN(Trip==97)=0;
        flow_slow_DON(Trip==97)=0;
        flow_slow_DIN(Trip==97)=0;
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% DON decomposition%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        a_stream=exp(-0.895); %Raymond 2012
        b_stream=0.38;  %Raymond 2012
%         Depth_fast=a_fast.*flow_fast_Water.^b_fast;
%         Depth_slow=a_slow.*flow_slow_Water.^b_slow;
        Depth_fast=1.0;
        Depth_slow=1.0;
        Depth_stream=max(a_stream.*((flow_stream_Water./86400.0).^b_stream),1.0);  % (flow_stream_Water./86400.0).^b_stream) from m3/d to m3/s; Depth unit m
        
        KPON_fast=0.028;
        KPON_stream=0.028; % Islam, 2012
%         flux_fast_PON= 0;
%         flux_stream_PON= 0;            
        flux_fast_PON = max(min((KPON_fast).*fT_PON(:,:,iday).*fast_PONp,fast_PONp-flow_fast_PON-min_sechiba),0);
        flux_stream_PON = max(min((KPON_stream).*fT_PON(:,:,iday).*stream_PONp,stream_PONp-flow_stream_PON-min_sechiba),0);

      
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% DON decomposition%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        KDON_fast=0.07;
        KDON_slow=0.07;
        KDON_stream=0.07; % Islam, 2012 %0.22
%         flux_fast_DON= 0;
%         flux_slow_DON= 0;            
        flux_fast_DON = max(min((KDON_fast).*fT_DON(:,:,iday).*fast_DONp,fast_DONp-flow_fast_DON-min_sechiba),0);
        flux_slow_DON = max(min((KDON_slow).*fT_DON(:,:,iday).*slow_DONp,slow_DONp-flow_slow_DON-min_sechiba),0);
        flux_stream_DON = max(min((KDON_stream).*fT_DON(:,:,iday).*stream_DONp,stream_DONp-flow_stream_DON-min_sechiba),0);
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% DIN denitrification %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      
        Vpot_dntr_fast=0.15; %0.23 
        Vpot_dntr_slow=0.15;  %0.23
        Vpot_dntr_stream=0.15; %0.23  % Wellheim 2008 m/d            Vpot_dntr_stream=0.0959
%         flux_fast_DINdntr=0;             
%         flux_slow_DINdntr=0;
        flux_fast_DINdntr=max(min((Vpot_dntr_fast./Depth_fast).*fT_DIN(:,:,iday).*fast_DINp,fast_DINp-flow_fast_DIN-min_sechiba),0);
        flux_slow_DINdntr=max(min((Vpot_dntr_slow./Depth_slow).*fT_DIN(:,:,iday).*slow_DINp,slow_DINp-flow_slow_DIN-min_sechiba),0);
        flux_stream_DINdntr=max(min((Vpot_dntr_stream./Depth_stream).*fT_DIN(:,:,iday).*stream_DINp,stream_DINp-flow_stream_DIN-min_sechiba),0);
            
        Runoffiday=Runoff(:,:,iday);
        Drainageiday=Drainage(:,:,iday);
        PONRiday=PONR(:,:,iday);
        DONRiday=DONR(:,:,iday);
        DONDiday=DOND(:,:,iday);
        DINRiday=DINR(:,:,iday);
        DINDiday=DIND(:,:,iday);
        Depth(:,:,iday)=Depth_stream;

        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  Trip~=97 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        
        fast_Waterp(Trip~=97)=max(fast_Waterp(Trip~=97)+Runoffiday(Trip~=97).*Area(Trip~=97)./1000.0-flow_fast_Water(Trip~=97),min_sechiba);  %m3
        % Area (m2)  
        slow_Waterp(Trip~=97)=max(slow_Waterp(Trip~=97)+Drainageiday(Trip~=97).*Area(Trip~=97)./1000.0-flow_slow_Water(Trip~=97),min_sechiba);  %m3
        stream_Waterp(Trip~=97)=max(stream_Waterp(Trip~=97)+flow_fast_Water(Trip~=97)+flow_slow_Water(Trip~=97)-flow_stream_Water(Trip~=97),min_sechiba); %m3
                
        fast_PONp(Trip~=97)=max(fast_PONp(Trip~=97)+PONRiday(Trip~=97)-flow_fast_PON(Trip~=97)-flux_fast_PON(Trip~=97),min_sechiba); 
        stream_PONp(Trip~=97)=max(stream_PONp(Trip~=97)+flow_fast_PON(Trip~=97)-flow_stream_PON(Trip~=97)-flux_stream_PON(Trip~=97),min_sechiba); 

        fast_DONp(Trip~=97)=max(fast_DONp(Trip~=97)+DONRiday(Trip~=97)-flow_fast_DON(Trip~=97)-flux_fast_DON(Trip~=97),min_sechiba); %gN/gride
        slow_DONp(Trip~=97)=max(slow_DONp(Trip~=97)+DONDiday(Trip~=97)-flow_slow_DON(Trip~=97)-flux_slow_DON(Trip~=97),min_sechiba);
        stream_DONp(Trip~=97)=max(stream_DONp(Trip~=97)+flow_fast_DON(Trip~=97)+flow_slow_DON(Trip~=97)-flow_stream_DON(Trip~=97)-flux_stream_DON(Trip~=97)+Nsewage(Trip~=97)*0.35,min_sechiba);
       
        fast_DINp(Trip~=97)=max(fast_DINp(Trip~=97)+DINRiday(Trip~=97)+flux_fast_PON(Trip~=97)+flux_fast_DON(Trip~=97)-flow_fast_DIN(Trip~=97)-flux_fast_DINdntr(Trip~=97),min_sechiba); %gN/gride  %
       %slow_DINp(Trip~=97)=max(slow_DINp(Trip~=97)+DINDiday(Trip~=97).*Area(Trip~=97)+flux_slow_DON(Trip~=97)-flow_slow_DIN(Trip~=97)-flux_slow_DINdntr(Trip~=97),min_sechiba);
        slow_DINp(Trip~=97)=max(slow_DINp(Trip~=97)+DINDiday(Trip~=97)+flux_slow_DON(Trip~=97)-flow_slow_DIN(Trip~=97)-flux_slow_DINdntr(Trip~=97),min_sechiba);
        stream_DINp(Trip~=97)=max(stream_DINp(Trip~=97)+flow_fast_DIN(Trip~=97)+flow_slow_DIN(Trip~=97)+flux_stream_PON(Trip~=97)+flux_stream_DON(Trip~=97)+...
                                   Nsewage(Trip~=97)*0.65-flow_stream_DIN(Trip~=97)-flux_stream_DINdntr(Trip~=97),min_sechiba);      
  
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  Trip==97 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        fast_Waterp(Trip==97)=max(fast_Waterp(Trip==97)+Runoffiday(Trip==97).*Area(Trip==97)./1000.0+flow_stream_Water(Trip==97)...
                                  -flow_fast_Water(Trip==97),min_sechiba);  %m3 flow_fast_Water is evaporated, Area (m2)    
        slow_Waterp(Trip==97)=max(slow_Waterp(Trip==97)+Drainageiday(Trip==97).*Area(Trip==97)./1000.0-flow_slow_Water(Trip==97),min_sechiba);  
        %m3  flow_fast_Water is evaporated in the end
        stream_Waterp(Trip==97)=max(stream_Waterp(Trip==97)-flow_stream_Water(Trip==97)+flow_slow_Water(Trip==97),min_sechiba); %m3 Flow_stream_Water to fast_Waterp
                
        fast_PONp(Trip==97)=max(fast_PONp(Trip==97)+PONRiday(Trip==97)+flow_stream_PON(Trip==97)-flux_fast_PON(Trip==97),min_sechiba); % No flow, all be decomposed to DIN
        stream_PONp(Trip==97)=max(stream_PONp(Trip==97)-flow_stream_PON(Trip==97)-flux_stream_PON(Trip==97),min_sechiba); % from upstream, to fast_PONp and decomposed to DIN

        fast_DONp(Trip==97)=max(fast_DONp(Trip==97)+DONRiday(Trip==97)-flux_fast_DON(Trip==97)+flow_stream_DON(Trip==97),min_sechiba); 
        %gN/gride, No flow, all be decomposed to DIN
        slow_DONp(Trip==97)=max(slow_DONp(Trip==97)+DONDiday(Trip==97)-flux_slow_DON(Trip==97),min_sechiba);
         %gN/gride, No flow, all be decomposed to DIN
        stream_DONp(Trip==97)=max(stream_DONp(Trip==97)-flow_stream_DON(Trip==97)-flux_stream_DON(Trip==97)+Nsewage(Trip==97)*0.35,min_sechiba); % from its upstream grid and to fast_DONp
            
        fast_DINp(Trip==97)=max(fast_DINp(Trip==97)+DINRiday(Trip==97)+flux_fast_PON(Trip==97)+flux_fast_DON(Trip==97)...
                                 -flux_fast_DINdntr(Trip==97)+flow_stream_DIN(Trip==97),min_sechiba); %gN/gride
        %gN/gride No flow, all be comsumed by denitrification
        slow_DINp(Trip==97)=max(slow_DINp(Trip==97)+DINDiday(Trip==97)+flux_slow_DON(Trip==97)-flux_slow_DINdntr(Trip==97),min_sechiba);
        %gN/gride No flow, all be comsumed by denitrification
        stream_DINp(Trip==97)=max(stream_DINp(Trip==97)+flux_stream_PON(Trip==97)+flux_stream_DON(Trip==97)+Nsewage(Trip==97)*0.65...
                                  -flow_stream_DIN(Trip==97)-flux_stream_DINdntr(Trip==97),min_sechiba);  
        
        for igrid=1:IDnum
            IDC=VID(igrid); % the calculating gride ID 
            idDown=TripdownID(IDC);
            stream_Waterp(idDown)=stream_Waterp(idDown)+flow_stream_Water(IDC);
            stream_PONp(idDown)=stream_PONp(idDown)+flow_stream_PON(IDC);
            stream_DONp(idDown)=stream_DONp(idDown)+flow_stream_DON(IDC);
            stream_DINp(idDown)=stream_DINp(idDown)+flow_stream_DIN(IDC);
        end                     

        flow_fast_water_day(:,:,iday)=flow_fast_Water;
        flow_fast_PON_day(:,:,iday)=flow_fast_PON;
        flow_fast_DON_day(:,:,iday)=flow_fast_DON;
        flow_fast_DIN_day(:,:,iday)=flow_fast_DIN;
        flow_slow_water_day(:,:,iday)=flow_slow_Water;
        flow_slow_DON_day(:,:,iday)=flow_slow_DON;
        flow_slow_DIN_day(:,:,iday)=flow_slow_DIN;
        flow_sream_water_day(:,:,iday)=flow_stream_Water;
        flow_sream_PON_day(:,:,iday)=flow_stream_PON;
        flow_sream_DON_day(:,:,iday)=flow_stream_DON;
        flow_sream_DIN_day(:,:,iday)=flow_stream_DIN;
        flux_sream_PON_day(:,:,iday)=flux_stream_PON;
        flux_fast_PON_day(:,:,iday)=flux_fast_PON;
        flux_sream_DON_day(:,:,iday)=flux_stream_DON;
        flux_fast_DON_day(:,:,iday)=flux_fast_DON;
        flux_slow_DON_day(:,:,iday)=flux_slow_DON;
        flux_sream_DIN_day(:,:,iday)=flux_stream_DINdntr;
        flux_fast_DINdntr_day(:,:,iday)=flux_fast_DINdntr;
        flux_slow_DINdntr_day(:,:,iday)=flux_slow_DINdntr;   
        disp(iday);
    end
    nccreate([output,'Day',num2str(year1),'.nc'],'FlowWater',...
    'Dimensions',{'x',rowA,'y',colA,'z',daynum},'FillValue','disable');
    ncwrite([output,'Day',num2str(year1),'.nc'],'FlowWater',flow_sream_water_day);
    
    nccreate([output,'Day',num2str(year1),'.nc'],'FlowPON',...
    'Dimensions',{'x',rowA,'y',colA,'z',daynum},'FillValue','disable');
    ncwrite([output,'Day',num2str(year1),'.nc'],'FlowPON',flow_sream_PON_day);
    
    nccreate([output,'Day',num2str(year1),'.nc'],'FlowDON',...
    'Dimensions',{'x',rowA,'y',colA,'z',daynum},'FillValue','disable');
    ncwrite([output,'Day',num2str(year1),'.nc'],'FlowDON',flow_sream_DON_day);
    
    nccreate([output,'Day',num2str(year1),'.nc'],'FlowDIN',...
    'Dimensions',{'x',rowA,'y',colA,'z',daynum},'FillValue','disable');
    ncwrite([output,'Day',num2str(year1),'.nc'],'FlowDIN',flow_sream_DIN_day);
    
    nccreate([output,'Day',num2str(year1),'.nc'],'FluxPON',...
    'Dimensions',{'x',rowA,'y',colA,'z',daynum},'FillValue','disable');
    ncwrite([output,'Day',num2str(year1),'.nc'],'FluxPON',flux_sream_PON_day);
    
    nccreate([output,'Day',num2str(year1),'.nc'],'FluxDON',...
    'Dimensions',{'x',rowA,'y',colA,'z',daynum},'FillValue','disable');
    ncwrite([output,'Day',num2str(year1),'.nc'],'FluxDON',flux_sream_DON_day);
    
    nccreate([output,'Day',num2str(year1),'.nc'],'FluxDIN',...
    'Dimensions',{'x',rowA,'y',colA,'z',daynum},'FillValue','disable');
    ncwrite([output,'Day',num2str(year1),'.nc'],'FluxDIN',flux_sream_DIN_day);
    

    
    flow_fast_water_year=sum(flow_fast_water_day,3); %  m3/year
    flow_fast_PON_year=sum(flow_fast_PON_day,3); %  m3/year
    flow_fast_DON_year=sum(flow_fast_DON_day,3); %  m3/year
    flow_fast_DIN_year=sum(flow_fast_DIN_day,3); %  m3/year
    flow_slow_water_year=sum(flow_slow_water_day,3); %  m3/year
    flow_slow_DON_year=sum(flow_slow_DON_day,3); %  m3/year
    flow_slow_DIN_year=sum(flow_slow_DIN_day,3); %  m3/year
    flow_sream_water_year=sum(flow_sream_water_day,3); %  m3/year
    flow_sream_PON_year=sum(flow_sream_PON_day,3); %  gN/year
    flow_sream_DON_year=sum(flow_sream_DON_day,3); %  gN/year
    flow_sream_DIN_year=sum(flow_sream_DIN_day,3); %  gN/year
    flux_sream_PON_year=sum(flux_sream_PON_day,3); %  gN/year
    flux_sream_DON_year=sum(flux_sream_DON_day,3); %  gN/year
    flux_sream_DIN_year=sum(flux_sream_DIN_day,3); %  gN/year
    flux_fast_PON_year=sum(flux_fast_PON_day,3); %  gN/year
    flux_fast_DON_year=sum(flux_fast_DON_day,3); %  gN/year
    flux_slow_DON_year=sum(flux_slow_DON_day,3); %  gN/year
    flux_fast_DINdntr_year=sum(flux_fast_DINdntr_day,3); %  gN/year
    flux_slow_DINdntr_year=sum(flux_slow_DINdntr_day,3); %  gN/year
    clear flow_fast_water_day flow_fast_PON_day flow_fast_DON_day flow_fast_DIN_day 
    clear flow_slow_water_day flow_slow_DON_day  flow_slow_DIN_day 
    clear flow_sream_water_day flow_sream_PON_day flow_sream_DON_day flow_sream_DIN_day
    clear flux_sream_PON_day flux_sream_DON_day flux_sream_DIN_day
    clear flux_fast_PON_day flux_fast_DON_day flux_fast_DINdntr_day
    clear flux_slow_DON_day flux_slow_DINdntr_day
    
    TSY=mean(TW,3); 
    RunoffY=sum(Runoff.*Area./1000,3);
    DrainageY=sum(Drainage.*Area./1000,3);
    PONRY=sum(PONR,3);  % gN/m^2/d,three-dimensional matrice 
    DONRY=sum(DONR,3);  % gN/m^2/d,three-dimensional matrice 
    DONDY=sum(DOND,3);  % gN/m^2/d,three-dimensional matrice 
    DINRY=sum(DINR,3);   % gN/m^2/d,three-dimensional matrice 
    DINDY=sum(DIND,3); % gN/m^2/d,three-dimensional matrice 
    DepthY=mean(Depth,3);

    clear TS Runoff Drainage PONR DONR DOND DINR DIND StreamIn StreamOut Nleach

    DepthY(Trip>100)=-1;
    TSY(Trip>100)=-1;
    RunoffY(Trip>100)=-1;
    DrainageY(Trip>100)=-1;
    PONRY(Trip>100)=-1;
    DONRY(Trip>100)=-1;
    DONDY(Trip>100)=-1;
    DINRY(Trip>100)=-1;
    DINDY(Trip>100)=-1;
    Nsewage(Trip>100)=-1;
    
    flow_fast_water_year(Trip>100)=-1;
    flow_fast_PON_year(Trip>100)=-1;
    flow_fast_DON_year(Trip>100)=-1;
    flow_fast_DIN_year(Trip>100)=-1;
    flow_slow_water_year(Trip>100)=-1;
    flow_slow_DON_year(Trip>100)=-1;
    flow_slow_DIN_year(Trip>100)=-1;
    flow_sream_water_year(Trip>100)=-1;
    flow_sream_PON_year(Trip>100)=-1;
    flow_sream_DON_year(Trip>100)=-1;
    flow_sream_DIN_year(Trip>100)=-1;
    flux_sream_PON_year(Trip>100)=-1;
    flux_sream_DON_year(Trip>100)=-1;
    flux_sream_DIN_year(Trip>100)=-1;
    flux_fast_PON_year(Trip>100)=-1;
    flux_fast_DON_year(Trip>100)=-1;
    flux_slow_DON_year(Trip>100)=-1;
    flux_fast_DINdntr_year(Trip>100)=-1;
    flux_slow_DINdntr_year(Trip>100)=-1;
    stream_Waterp(Trip>100)=-1;
    stream_PONp(Trip>100)=-1;
    stream_DONp(Trip>100)=-1;
    stream_DINp(Trip>100)=-1;
    fast_Waterp(Trip>100)=-1;
    fast_PONp(Trip>100)=-1;
    fast_DONp(Trip>100)=-1;
    fast_DINp(Trip>100)=-1;
    slow_Waterp(Trip>100)=-1;
    slow_DONp(Trip>100)=-1;
    slow_DINp(Trip>100)=-1;
    
    datasaveIN(i,1)=mean(mean(TSY(TSY>-1)));
    datasaveIN(i,2)=sum(sum(RunoffY(RunoffY>-1)));
    datasaveIN(i,3)=sum(sum(DrainageY(DrainageY>-1)));
    datasaveIN(i,4)=sum(sum(PONRY(PONRY>-1)));
    datasaveIN(i,5)=sum(sum(DONRY(DONRY>-1)));
    datasaveIN(i,6)=sum(sum(DONDY(DONDY>-1)));
    datasaveIN(i,7)=sum(sum(DINRY(DINRY>-1)));
    datasaveIN(i,8)=sum(sum(DINDY(DINDY>-1)));
    datasaveIN(i,9)=sum(sum(Nsewage(Nsewage>-1))).*365;

    datasave(i,1)=sum(flow_sream_water_year(Trip==98))+sum(flow_sream_water_year(Trip==99))+...
        sum(flow_fast_water_year(Trip==97));
    datasave(i,2)=sum(sum(flow_sream_water_year(flow_sream_water_year>-1)));
    datasave(i,3)=sum(sum(stream_Waterp(stream_Waterp>-1)));
    datasave(i,4)=sum(sum(flow_fast_water_year(flow_fast_water_year>-1)));
    datasave(i,5)=sum(sum(fast_Waterp(fast_Waterp>-1)));
    datasave(i,6)=sum(sum(flow_slow_water_year(flow_slow_water_year>-1)));
    datasave(i,7)=sum(sum(slow_Waterp(slow_Waterp>-1)));
    
    datasave(i,8)=sum(flow_sream_PON_year(Trip==98))+sum(flow_sream_PON_year(Trip==99));
    datasave(i,9)=sum(sum(flow_sream_PON_year(flow_sream_PON_year>-1)));
    datasave(i,10)=sum(sum(flux_sream_PON_year(flux_sream_PON_year>-1)));
    datasave(i,11)=sum(sum(stream_PONp(stream_PONp>-1)));
    datasave(i,12)=sum(sum(flow_fast_PON_year(flow_fast_PON_year>-1)));
    datasave(i,13)=sum(sum(flux_fast_PON_year(flux_fast_PON_year>-1)));
    datasave(i,14)=sum(sum(fast_PONp(fast_PONp>-1)));
    
    datasave(i,15)=sum(flow_sream_DON_year(Trip==98))+sum(flow_sream_DON_year(Trip==99));
    datasave(i,16)=sum(sum(flow_sream_DON_year(flow_sream_DON_year>-1)));
    datasave(i,17)=sum(sum(flux_sream_DON_year(flux_sream_DON_year>-1)));
    datasave(i,18)=sum(sum(stream_DONp(stream_DONp>-1)));
    datasave(i,19)=sum(sum(flow_fast_DON_year(flow_fast_DON_year>-1)));
    datasave(i,20)=sum(sum(flux_fast_DON_year(flux_fast_DON_year>-1)));
    datasave(i,21)=sum(sum(fast_DONp(fast_DONp>-1)));
    datasave(i,22)=sum(sum(flow_slow_DON_year(flow_slow_DON_year>-1)));
    datasave(i,23)=sum(sum(flux_slow_DON_year(flux_slow_DON_year>-1)));
    datasave(i,24)=sum(sum(slow_DONp(slow_DONp>-1)));
    
    datasave(i,25)=sum(flow_sream_DIN_year(Trip==98))+sum(flow_sream_DIN_year(Trip==99));
    datasave(i,26)=sum(sum(flow_sream_DIN_year(flow_sream_DIN_year>-1))); 
    datasave(i,27)=sum(sum(flux_sream_DIN_year(flux_sream_DIN_year>-1)));
    datasave(i,28)=sum(sum(stream_DINp(stream_DINp>-1)));
    datasave(i,29)=sum(sum( flow_fast_DIN_year(flow_fast_DIN_year>-1)));
    datasave(i,30)=sum(sum(flux_fast_DINdntr_year(flux_fast_DINdntr_year>-1)));
    datasave(i,31)=sum(sum(fast_DINp(fast_DINp>-1)));
    
    datasave(i,32)=sum(sum(flow_slow_DIN_year(flow_slow_DIN_year>-1)));
    datasave(i,33)=sum(sum(flux_slow_DINdntr_year(flux_slow_DINdntr_year>-1)));
    datasave(i,34)=sum(sum(slow_DINp(slow_DINp>-1)));
    
    TSY(isnan(TSY))=0;
    RunoffY(isnan(RunoffY))=0;
    DrainageY(isnan(DrainageY))=0;
    PONRY(isnan(PONRY))=0;
    DONRY(isnan(DONRY))=0;
    DONDY(isnan(DONDY))=0;
    DINRY(isnan(DINRY))=0;
    DINDY(isnan(DINDY))=0;
    
    Basindata=zeros(BasinNum,21);
    Trip98=zeros(360,720);
    Trip99=zeros(360,720);
    Trip98(Trip==98)=1;
    Trip99(Trip==99)=1;
   
    nccreate([output,'Year',num2str(year1),'.nc'],'FlowPON',...
        'Dimensions',{'x',rowA,'y',colA,'z',1},'FillValue','disable');
    ncwrite([output,'Year',num2str(year1),'.nc'],'FlowPON',flow_sream_PON_year);
    
    nccreate([output,'Year',num2str(year1),'.nc'],'FlowDON',...
        'Dimensions',{'x',rowA,'y',colA,'z',1},'FillValue','disable');
    ncwrite([output,'Year',num2str(year1),'.nc'],'FlowDON',flow_sream_DON_year);
    
    nccreate([output,'Year',num2str(year1),'.nc'],'FlowDIN',...
        'Dimensions',{'x',rowA,'y',colA,'z',1},'FillValue','disable');
    ncwrite([output,'Year',num2str(year1),'.nc'],'FlowDIN',flow_sream_DIN_year);
    
    nccreate([output,'Year',num2str(year1),'.nc'],'FluxPON',...
        'Dimensions',{'x',rowA,'y',colA,'z',1},'FillValue','disable');
    ncwrite([output,'Year',num2str(year1),'.nc'],'FluxPON',flux_sream_PON_year);
    
    nccreate([output,'Year',num2str(year1),'.nc'],'FluxDON',...
        'Dimensions',{'x',rowA,'y',colA,'z',1},'FillValue','disable');
    ncwrite([output,'Year',num2str(year1),'.nc'],'FluxDON',flux_sream_DON_year);
    
    nccreate([output,'Year',num2str(year1),'.nc'],'FluxDIN',...
        'Dimensions',{'x',rowA,'y',colA,'z',1},'FillValue','disable');
    ncwrite([output,'Year',num2str(year1),'.nc'],'FluxDIN',flux_sream_DIN_year);
    
    nccreate([output,'Year',num2str(year1),'.nc'],'stream_Waterp',...
        'Dimensions',{'x',rowA,'y',colA,'z',1},'FillValue','disable');
    ncwrite([output,'Year',num2str(year1),'.nc'],'stream_Waterp',stream_Waterp);
    
    nccreate([output,'Year',num2str(year1),'.nc'],'stream_PONp',...
        'Dimensions',{'x',rowA,'y',colA,'z',1},'FillValue','disable');
    ncwrite([output,'Year',num2str(year1),'.nc'],'stream_PONp',stream_PONp);
    
    nccreate([output,'Year',num2str(year1),'.nc'],'stream_DONp',...
        'Dimensions',{'x',rowA,'y',colA,'z',1},'FillValue','disable');
    ncwrite([output,'Year',num2str(year1),'.nc'],'stream_DONp',stream_DONp);
    
    nccreate([output,'Year',num2str(year1),'.nc'],'stream_DINp',...
        'Dimensions',{'x',rowA,'y',colA,'z',1},'FillValue','disable');
    ncwrite([output,'Year',num2str(year1),'.nc'],'stream_DINp',stream_DINp);
    
end % end of year
datasave1=datasave./(10^12);
datasaveIN1=datasaveIN./(10^12);
xlswrite([outputt,'datasaveCheckAll33T900.xlsx'],datasave1,'Sum','B3')
xlswrite([outputt,'datasaveCheckAll33T900.xlsx'],datasaveIN1,'IN','B3')
toc;
